<?php
include 'includes/header.php';


// Check if the wishlist array exists in the session
if (isset($_SESSION['wishlist']) && !empty($_SESSION['wishlist'])) {
    $wishlist = $_SESSION['wishlist'];
    // You have wishlist data available in the $wishlist array
}

?>
     <!-- header-end -->

    

    <main>
        <!-- page-banner-area-start -->
        <div class="page-banner-area page-banner-height-2" data-background="assets/img/banner/page_content.png">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="page-banner-content text-center">
                            <h4 class="breadcrumb-title">Wishlist</h4>
                            <div class="breadcrumb-two">
                                <nav>
                                   <nav class="breadcrumb-trail breadcrumbs">
                                      <ul class="breadcrumb-menu">
                                         <li class="breadcrumb-trail">
                                            <a href="index.php"><span>Home</span></a>
                                         </li>
                                         <li class="trail-item">
                                            <span>Wishlist</span>
                                         </li>
                                      </ul>
                                   </nav> 
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- page-banner-area-end -->

        <!-- cart-area-start -->
        <section class="cart-area pb-120 pt-120">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <form action="#">
                            <div class="table-content table-responsive">
                                <table class="table" id="wishlist_table">
                                    <thead>
                                        <tr>
                                            <th class="product-thumbnail">Images</th>
                                            <th class="cart-product-name">Product</th>
                                            <th class="product-price">Unit Price</th>
                                            <th class="product-quantity">Add To Cart</th>
                                            <th class="product-subtotal">Total</th>
                                            <th class="product-remove">Remove</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (isset($_SESSION['user_id']) && !empty($wishlist)) {
                                            // Loop through the wishlist products and display them
                                            foreach ($wishlist as $product) {
                                        ?>
                                        <tr>
                                            <td class="product-thumbnail">
                                                <a href="shop-details.php">
                                                    <img src="./admin/uploads/<?php echo $product['ProductMainImage']; ?>" alt="">
                                                </a>
                                            </td>
                                            <td class="product-name">
                                                <a href="shop-details.php"><?php echo $product['ProductName']; ?></a>
                                            </td>
                                            <td class="product-price"><span class="amount"><?php echo $product['Price']; ?></span></td>
                                            <td class="product-quantity">
                                                <button class="wishlist-cart-btn tp-btn-h1" type="submit" data-product-id="<?php echo $product['id']; ?>">Add To Cart</button>
                                            </td>
                                            <td class="product-subtotal"><span class="amount"><?php echo $product['Price']; ?></span></td>
                                            <td class="product-remove">
                                                <a href="#" class="remove-from-wishlist" data-product-id="<?php echo $product['id']; ?>"><i class="fa fa-times"></i></a>
                                            </td>
                                        </tr>
                                        <?php
                                            }
                                        } else {
                                            echo '<tr><td colspan="6">No products in the wishlist.</td></tr>';
                                        }
                                        ?>
                                    </tbody>

                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
         <!-- cart-area-end -->

        <!-- cta-area-start -->
        <!--<section class="cta-area d-ldark-bg pt-55 pb-10">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item cta-item-d mb-30">
                            <h5 class="cta-title">Follow Us</h5>
                            <p>We make consolidating, marketing and tracking your social media website easy.</p>
                            <div class="cta-social">
                                <div class="social-icon">
                                    <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#" class="twitter"><i class="fab fa-twitter"></i></a>
                                    <a href="#" class="youtube"><i class="fab fa-youtube"></i></a>
                                    <a href="#" class="linkedin"><i class="fab fa-linkedin-in"></i></a>
                                    <a href="#" class="rss"><i class="fas fa-rss"></i></a>
                                    <a href="#" class="dribbble"><i class="fab fa-dribbble"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item mb-30">
                            <h5 class="cta-title">Sign Up To Newsletter</h5>
                            <p>Join 60.000+ subscribers and get a new discount coupon  on every Saturday.</p>
                            <div class="subscribe__form">
                                <form action="#">
                                    <input type="email" placeholder="Enter your email here...">
                                    <button>subscribe</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item mb-30">
                            <h5 class="cta-title">Download App</h5>
                            <p>DukaMarket App is now available on App Store & Google Play. Get it now.</p>
                            <div class="cta-apps">
                                <div class="apps-store">
                                    <a href="#"><img src="assets/img/brand/app_ios.png" alt=""></a>
                                    <a href="#"><img src="assets/img/brand/app_android.png" alt=""></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>-->
        <!-- cta-area-end -->
        
         <!-- brand-area-start -->
        <?php include 'includes/brands.php';  ?>
        <!-- brand-area-end -->

    </main>
    
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
  <script>
// JavaScript code to remove products from the wishlist

$(document).ready(function () {
    // Attach a click event handler to "Remove" links
    $(".remove-from-wishlist").on("click", function (e) {
        e.preventDefault();

        // Get the product ID from the data attribute
        var productId = $(this).data("product-id");

        // Find the product in the displayed list and remove it
        var $productRow = $(".wishlist-item[data-product-id='" + productId + "']");
        
        // Remove the product from the displayed list
        $productRow.remove();

        // Send an AJAX request to remove the product from the wishlist
        $.ajax({
            type: "POST",
            url: "remove_from_wishlist.php", // URL to handle removal
            data: { product_id: productId },
            success: function (response) {
                // Log the response to the console for debugging
                // console.log(response);

                // Parse the JSON response
                var result = JSON.parse(response);

                if (result.success) {
                    location.reload();
                } else {
                    // Handle errors
                    alert("Failed to remove product from wishlist: " + result.message);
                    
                    // Since the server-side removal failed, you may consider adding the item back to the displayed list
                    // $wishlistContainer.append($productRow); // Uncomment this line if needed
                }
            }
        });
    });
});
</script>

<script>
    // JavaScript code for adding products to the cart from the wishlist

// Function to add a product to the cart
function addToCartFromWishlist(productId) {
    // You can send an AJAX request to your server to add the product to the user's cart
    // Here's a simplified example using jQuery for AJAX

    $.ajax({
        type: "POST",
        url: "add_to_cart.php", // Replace with the actual URL to handle cart additions
        data: { product_id: productId },
        success: function (response) {
            // Parse the JSON response
            var result = JSON.parse(response);

            if (result.success) {
                // Product added to cart successfully
                // alert("Product added to your cart!");
                $("#cart").load(location.href + " #cart");
            } else if (result.already_in_cart) {
                // Product is already in the cart
                alert("Product is already in your cart.");
            } else if (result.error) {
                // Handle other errors
                alert(result.error);
            } else {
                alert("Unknown error occurred.");
            }
        },
        error: function () {
            // Handle AJAX request errors
            alert("AJAX request failed.");
        }
    });
}

// Attach a click event handler to the "Add To Cart" button in the wishlist
$(document).ready(function () {
    $(".wishlist-cart-btn").on("click", function (e) {
        e.preventDefault();

        // Get the product ID from a data attribute or another method
        var productId = $(this).data("product-id");

        // Call the addToCartFromWishlist function to add the product to the cart
        addToCartFromWishlist(productId);
    });
});

</script>



    <!-- footer-start -->
    <?php
include 'includes/footer.php';
?>