<?php
include 'includes/header.php';
include 'includes/db_config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// $category_id = $_GET['category_id'];
?>
     <!-- header-end -->

    

    <main>
        <!-- breadcrumb__area-start -->
        <section class="breadcrumb__area box-plr-75">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="breadcrumb__wrapper">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                  <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                                  <li class="breadcrumb-item active" aria-current="page">Shop</li>
                                </ol>
                              </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb__area-end -->

        <!-- shop-area-start -->
        <div class="shop-area mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-4">
                        <div class="product-widget mb-30">
                            <h5 class="pt-title">Product categories</h5>
                            <div class="widget-category-list mt-20">
                                <!--<form action="#">-->
                                    <div class="single-widget-category">
                                        <?php
                                        // Assuming you have already established a database connection.
                                        
                                        // Replace 'your_database_table' with the actual name of your database table.
                                        $categoryQuery = "SELECT * FROM Category";
                                        $categoryResult = mysqli_query($conn, $categoryQuery); // Replace $your_db_connection with your actual database connection.
                            
                                        while ($categoryRow = mysqli_fetch_assoc($categoryResult)) {
                                            $categoryId = $categoryRow['id'];
                                            $categoryName = $categoryRow['CategoryName'];
                                            $slug = $categoryRow['slug'];
                                            $categoryCount = 0; // You can retrieve the count of products in each category if needed.
                            
                                            // echo '<input type="checkbox" id="cat-item-' . $categoryId . '" name="cat-item">';
                                            echo '<a href="shop.php?slug=' . $slug . '" for="cat-item-' . $categoryId . '">' . $categoryName . '</a>';
                                            echo '</div>';
                                            echo '<div class="single-widget-category">';
                                        }
                                        ?>
                            
                                    </div>
                                <!--</form>-->
                            </div>

                        </div>
                        
                    </div>
                    <div class="col-xl-9 col-lg-8">
                        <div class="shop-banner mb-30">
                            <div class="banner-image">
                                <img class="banner-l" src="assets/img/banner/sl-banner.jpg" alt="">
                                <img class="banner-sm" src="assets/img/banner/sl-banner-sm.png" alt="">
                                <div class="banner-content text-center">
                                    <p class="banner-text mb-30">Hurry Up! <br> Free Shipping All Order Over $99</p>
                                    <a href="shop.php" class="st-btn-d b-radius">Discover now</a>
                                </div>
                            </div>
                        </div>
                        <div class="product-lists-top">
                            <div class="product__filter-wrap">
                                <div class="row align-items-center">
                                    <!--<div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">-->
                                    <!--    <div class="product__filter d-sm-flex align-items-center">-->
                                    <!--        <div class="product__col">-->
                                    <!--            <ul class="nav nav-tabs" id="myTab" role="tablist">-->
                                    <!--                <li class="nav-item" role="presentation">-->
                                    <!--                  <button class="nav-link active" id="FourCol-tab" data-bs-toggle="tab" data-bs-target="#FourCol" type="button" role="tab" aria-controls="FourCol" aria-selected="true">-->
                                    <!--                    <i class="fal fa-th"></i>-->
                                    <!--                  </button>-->
                                    <!--                </li>-->
                                    <!--                <li class="nav-item" role="presentation">-->
                                    <!--                  <button class="nav-link" id="FiveCol-tab" data-bs-toggle="tab" data-bs-target="#FiveCol" type="button" role="tab" aria-controls="FiveCol" aria-selected="false">-->
                                    <!--                    <i class="fal fa-list"></i>-->
                                    <!--                  </button>-->
                                    <!--                </li>-->
                                    <!--              </ul>-->
                                    <!--        </div>-->
                                            
                                    <!--    </div>-->
                                    <!--</div>-->
                                </div>
                        </div>
                        </div>
                        <div class="tab-content" id="productGridTabContent">
                            <div class="tab-pane fade  show active" id="FourCol" role="tabpanel" aria-labelledby="FourCol-tab">
                                <div class="tp-wrapper">
                                    <div class="row g-0">
                                        
                                        <?php
                                        // Assuming you have already established a database connection.
                                        // Define your category ID and pagination parameters.
                                            $Cslug = isset($_GET['slug']) ? $_GET['slug'] : '';
                                            $cat = "SELECT id FROM Category WHERE slug = '$Cslug'";
                                            $Catresult = mysqli_query($conn, $cat);
                                            if (mysqli_num_rows($Catresult) > 0) {
                                                $Catrow = mysqli_fetch_assoc($Catresult);
                                                $category_id = $Catrow['id'];
                                                mysqli_free_result($Catresult);
                                            } 
                                            
                                            
                                            $itemsPerPage = 20; // Adjust this to your preferred number.
                                            $currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                                            $offset = ($currentPage - 1) * $itemsPerPage;
                                            
                                            // Replace 'your_database_table' with the actual name of your database table.
                                            $query = "SELECT * FROM Product WHERE ProductCategories = $category_id LIMIT $itemsPerPage OFFSET $offset";
                                            $result = mysqli_query($conn, $query); // Replace $your_db_connection with your actual database connection.
                                            
                                            // Calculate the total number of products in the category.
                                            $query1 = "SELECT COUNT(*) as total FROM Product WHERE ProductCategories = $category_id";
                                            $result1 = mysqli_query($conn, $query1);
                                            $totalProducts = mysqli_fetch_assoc($result1)['total'];
                                            
                                            // Calculate the total number of pages.
                                            $totalPages = ceil($totalProducts / $itemsPerPage);
                                        if ($result) {
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            $product_id = $row['id'];
                                            $product_name = $row['ProductName'];
                                            $product_price = $row['Price'];
                                            $product_image = $row['ProductMainImage'];
                                            $prodSlug = $row['slug'];
                                            // You can retrieve additional fields as needed.
                                        
                                            echo '<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">';
                                            echo '<div class="product__item product__item-d">';
                                            echo '<div class="product__thumb fix">';
                                            echo '<div class="product-image w-img">';
                                            echo '<a href="product-details.php?slug=' . $prodSlug . '">';
                                            echo '<img src="./admin/uploads/' . $product_image . '" alt="' . $product_name . '">';
                                            echo '</a>';
                                            echo '</div>';
                                            echo '<div class="product-action">';
                                            echo '<a href="' . (isset($_SESSION['user_id']) ? '' : 'my-account.php') . '" class="icon-box icon-box-1' . (isset($_SESSION['user_id']) ? ' wish1' : '') . '"' . (isset($_SESSION['user_id']) ? ' data-product-id="' . $product_id . '"' : '') . '>';
                                            echo '<i class="fal fa-heart"></i>';
                                            echo '<i class="fal fa-heart"></i>';
                                            echo '</a>';
                                            echo '<a href="#" class="icon-box icon-box-1">';
                                            echo '<i class="fal fa-layer-group"></i>';
                                            echo '<i class="fal fa-layer-group"></i>';
                                            echo '</a>';
                                            echo '</div>';
                                            echo '</div>';
                                            echo '<div class="product__content-3">';
                                            echo '<h6><a href="product-details.php?slug=' . $prodSlug . '">' . $product_name . '</a></h6>';
                                            echo '<div class="rating mb-5">';
                                            echo '<ul>';
                                            echo '<li><a href="#"><i class="fal fa-star"></i></a></li>';
                                            echo '<li><a href="#"><i class="fal fa-star"></i></a></li>';
                                            echo '<li><a href="#"><i class="fal fa-star"></i></a></li>';
                                            echo '<li><a href="#"><i class="fal fa-star"></i></a></li>';
                                            echo '<li><a href="#"><i class="fal fa-star"></i></a></li>';
                                            echo '</ul>';
                                            echo '<span>(01 review)</span>';
                                            echo '</div>';
                                            echo '<div class="price mb-10">';
                                            echo '<span>' . $product_price . '</span>';
                                            echo '</div>';
                                            echo '</div>';
                                            echo '<div class="product__add-cart-s text-center">';
                                            echo '<button type="button" class="cart-btn d-flex mb-10 align-items-center justify-content-center w-100" data-product-id="'.$product_id.'">';
                                            echo 'Add to Cart';
                                            echo '</button>';
                                            echo '</div>';
                                            echo '</div>';
                                            echo '</div>';
                                        }
                                        } else {
                                                // Handle the case where the query fails (e.g., display an error message).
                                                echo "Error: " . mysqli_error($conn);
                                            }
                                        ?>

                                        
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tp-pagination text-center">
                            <div class="row">
                                <div class="col-xl-12">
                                     <div class="basic-pagination pt-30 pb-30">
                                            <nav>
                                                <ul>
                                                    <?php
                                                    for ($page = 1; $page <= $totalPages; $page++) {
                                                        echo '<li>';
                                                        if ($page == $currentPage) {
                                                            echo '<a href="shop.php?page=' . $page . '&slug=' .  $Cslug . '" class="active">' . $page . '</a>';
                                                        } else {
                                                            echo '<a href="shop.php?page=' . $page . '&slug=' .  $Cslug . '">' . $page . '</a>';
                                                        }
                                                        echo '</li>';
                                                    }
                                                    ?>
                                                </ul>
                                            </nav>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- shop-area-end -->

    </main>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
// JavaScript code for adding products to the wishlist

// Function to add a product to the wishlist
function addToWishlist(productId) {
    // You can send an AJAX request to your server to add the product to the user's wishlist
    // Here's a simplified example using jQuery for AJAX

    $.ajax({
        type: "POST",
        url: "add_to_wishlist.php", // Replace with the actual URL to handle wishlist actions
        data: { product_id: productId },
        success: function (response) {
            // Parse the JSON response
            var result = JSON.parse(response);

            if (result.success) {
                // Wishlist item added successfully
                // alert("Product added to your wishlist!");
                // location.reload();
                $("#wishlist").load(location.href + " #wishlist");
            } else if (result.already_in_wishlist) {
                // Product is already in the wishlist
                alert("Product is already in your wishlist.");
            } else {
                // Handle other errors
                alert("Failed to add product to wishlist.");
            }
        }
    });
}

// Attach a click event handler to the heart icon
$(document).ready(function () {
    $(".wish1").on("click", function (e) {
        e.preventDefault();

        // Get the product ID from a data attribute or another method
        var productId = $(this).data("product-id");

        // Call the addToWishlist function to add the product to the wishlist
        addToWishlist(productId);
    });
});
</script>

<script>
    // JavaScript code for adding products to the cart

    // Function to add a product to the cart
    function addToCart(productId) {
        // You can send an AJAX request to your server to add the product to the user's cart
        // Here's a simplified example using jQuery for AJAX

        $.ajax({
            type: "POST",
            url: "add_to_cart.php", // Replace with the actual URL to handle cart additions
            data: { product_id: productId },
            success: function (response) {
                // Parse the JSON response
                var result = JSON.parse(response);

                if (result.success) {
                    // Product added to cart successfully
                    // alert("Product added to your cart!");
                    // location.reload();
                    $("#cart").load(location.href + " #cart");
                } else if (result.already_in_cart) {
                    // Product is already in the cart
                    alert("Product is already in your cart.");
                } else if (result.error) {
                    // Handle other errors
                    alert(result.error);
                } else {
                    alert("Unknown error occurred.");
                }
            },
            error: function () {
                // Handle AJAX request errors
                alert("AJAX request failed.");
            }
        });
    }

    // Attach a click event handler to the "Add to Cart" button
    $(document).ready(function () {
        $(".cart-btn").on("click", function (e) {
            e.preventDefault();

            // Get the product ID from a data attribute or another method
            var productId = $(this).data("product-id");

            // Call the addToCart function to add the product to the cart
            addToCart(productId);
        });
    });
</script>


    <!-- footer-start -->
    <?php
include 'includes/footer.php';
?>