<?php
session_start();

if (isset($_POST['product_id'])) {
    $product_id = $_POST['product_id'];

    if (isset($_SESSION['wishlist'])) {
        $removed = false;

        // Find and remove the product with the specified ID from the wishlist
        foreach ($_SESSION['wishlist'] as $key => $product) {
            if ($product['id'] == $product_id) {
                unset($_SESSION['wishlist'][$key]);
                $removed = true;
                break; // Stop searching after removal
            }
        }

        if ($removed) {
            $response = array("success" => true, "message" => "Product removed from wishlist.");
        } else {
            $response = array("success" => false, "message" => "Product not found in wishlist.");
        }
    } else {
        $response = array("success" => false, "message" => "Wishlist is empty.");
    }
} else {
    $response = array("success" => false, "message" => "Product ID is missing.");
}

echo json_encode($response);
?>
