<?php
session_start();

if (isset($_POST['product_id'])) {
    $product_id = $_POST['product_id'];

    if (isset($_SESSION['cart'])) {
        $removed = false;

        // Find and remove the product with the specified ID from the cart
        foreach ($_SESSION['cart'] as $key => $product) {
            if ($product['id'] == $product_id) {
                unset($_SESSION['cart'][$key]);
                $removed = true;
                break; // Stop searching after removal
            }
        }

        if ($removed) {
            $response = array("success" => true, "message" => "Product removed from cart");
        } else {
            $response = array("success" => false, "message" => "Product not found in cart");
        }
    } else {
        $response = array("success" => false, "message" => "Cart is empty");
    }
} else {
    $response = array("success" => false, "message" => "Product ID is missing");
}

echo json_encode($response);
?>
