<?php
session_start();
include 'includes/db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = file_get_contents('php://input');
    $postData = json_decode($data, true);

    if ($postData !== null) {
        $transactionId = $postData['transactionId'];
        $paymentMethod = 'Paypal';
        $formData = $postData['formData'];
        $customerId = $_SESSION['user_id'];
        $trackingNo = generateTrackingNumber();
        $timeOrdered = date('Y-m-d H:i:s');
        $amountPaid = $formData['total'];
        $totalAmount = $formData['total'];

        $quantities = $formData['quantities'];

        $sqlCustomer = "UPDATE Customers
            SET Country = '{$formData['country']}',
                Address = '{$formData['address']}',
                City = '{$formData['city']}',
                State = '{$formData['state']}',
                ZipCode = '{$formData['postcode']}',
                PhoneNumber = '{$formData['phone']}'
            WHERE id = $customerId";

        if ($conn->query($sqlCustomer) === TRUE) {
            $sqlOrder = "INSERT INTO Orders (tracking_no, CustomerID, AmountPaid, TotalAmount, transaction_id, payment_method)
            VALUES ('$trackingNo', $customerId, $amountPaid, $totalAmount, '$transactionId', '$paymentMethod')";

            if ($conn->query($sqlOrder) === TRUE) {
                $orderID = generateOrderID();
                // Extract product data from the cart session and insert into order_items
                foreach ($_SESSION['cart'] as $product) {
                    $prodID = $product['id'];
                    $qty = $quantities[$prodID];
                    $price = $product['Price'];

                    // Check if any of the essential data is missing
                    if (!empty($orderID) && is_numeric($prodID) && is_numeric($qty) && is_numeric($price)) {
                        $sqlOrderItems = "INSERT INTO order_items (order_id, prod_id, qty, price, created_at)
                            VALUES ('$orderID', $prodID, $qty, $price, CURRENT_TIMESTAMP)";

                        // Execute the order items insertion query
                        if ($conn->query($sqlOrderItems) !== TRUE) {
                            // Handle error in inserting order items
                            http_response_code(500);
                            echo json_encode(['error' => 'Error inserting order items: ' . $conn->error]);
                            exit();
                        }
                        
                        if ($conn->query($sqlOrderItems) == TRUE) {
                             // Remove cart items from the session
                                if (isset($_SESSION['cart'])) {
                                    unset($_SESSION['cart']);
                                }
                        }
                        
                    } else {
                        // Handle the case where essential data is missing or invalid
                        http_response_code(400); // Bad Request
                        echo json_encode(['error' => 'Invalid or missing order item data']);
                        exit();
                    }
                }

                $response = [
                    'message' => 'Order data received and processed successfully',
                ];
                echo json_encode($response);
            } else {
                // Error inserting order details
                http_response_code(500);
                echo json_encode(['error' => 'Error inserting order details: ' . $conn->error]);
            }
        } else {
            // Error updating customer information
            http_response_code(500);
            echo json_encode(['error' => 'Error updating customer information: ' . $conn->error]);
        }
    } else {
        // JSON data couldn't be decoded
        error_log('Error: Invalid JSON data'); // Debugging: Log the case where JSON data couldn't be decoded
        http_response_code(400);
        echo json_encode(['error' => 'Invalid JSON data']);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}

function generateTrackingNumber() {
    return 'TRK' . date('YmdHis') . substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 6);
}

function generateOrderID() {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $orderID = 'ORDER-';
    for ($i = 0; $i < 8; $i++) {
        $orderID .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $orderID;
}
?>
