<?php
session_start();
include 'includes/db_config.php';
?>


<!doctype html>
<html class="no-js" lang="zxx">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="x-ua-compatible" content="ie=edge">
      <title>Saninfosys</title>
      <meta name="description" content="">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <!-- Place favicon.ico in the root directory -->
      <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
      <!-- CSS here -->
      <link rel="stylesheet" href="assets/css/preloader.css">
      <link rel="stylesheet" href="assets/css/bootstrap.css">
      <link rel="stylesheet" href="assets/css/meanmenu.css">
      <link rel="stylesheet" href="assets/css/animate.css">
      <link rel="stylesheet" href="assets/css/owl-carousel.css">
      <link rel="stylesheet" href="assets/css/swiper-bundle.css">
      <link rel="stylesheet" href="assets/css/backtotop.css">
      <link rel="stylesheet" href="assets/css/magnific-popup.css">
      <link rel="stylesheet" href="assets/css/nice-select.css">
      <link rel="stylesheet" href="assets/flaticon/flaticon.css">
      <link rel="stylesheet" href="assets/css/font-awesome-pro.css">
      <link rel="stylesheet" href="assets/css/default.css">
      <link rel="stylesheet" href="assets/css/style.css">
   </head>
   <style>
       .page-banner-height-2 {
    min-height: 203px;
}
.page-banner-height {
    padding: 50px 0;
}
   </style>
   <body>
     
    <!-- back to top start -->
    <div class="progress-wrap">
         <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
         </svg>
    </div>
      <!-- back to top end -->
      
    <!-- header-start -->
    <header class="header d-blue-bg">
        <div class="header-top">
            <div class="container">
                <div class="header-inner">
                    <div class="row align-items-center">
                        <div class="col-xl-6 col-lg-7">
                            <div class="header-inner-start">
                                <!-- <div class="header__currency border-right">
                                    <div class="s-name">
                                        <span>Language: </span>
                                    </div>
                                    <select>
                                        <option>English</option>
                                        <option>Deutsch</option>
                                        <option>Français</option>
                                        <option>Espanol</option>
                                    </select>
                                </div>
                                <div class="header__lang border-right">
                                    <div class="s-name">
                                        <span>Currency: </span>
                                    </div>
                                    <select>
                                        <option> USD</option>
                                        <option>EUR</option>
                                        <option>INR</option>
                                        <option>BDT</option>
                                        <option>BGD</option>
                                    </select>
                                </div> -->
                                <div class="support d-none d-sm-block">
                                    <p>Need Help? <a href="tel:+91 98991 21233">+91 98991 21233</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-5 d-none d-lg-block">
                            <div class="header-inner-end text-md-end">
                                <div class="ovic-menu-wrapper">
                                    <ul>
                                        <li><a href="about.php">About Us</a></li>
                                        <li><a href="contact.php">Order Tracking</a></li>
                                        <li><a href="contact.php">Contact Us</a></li>
                                        <li><a href="faq.php">FAQs</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-mid">
            <div class="container">
                <div class="heade-mid-inner">
                    <div class="row align-items-center">
                        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4">
                            <div class="header__info">
                                <div class="logo">
                                    <a href="index.php" class="logo-image"><img src="assets/img/logo/San5.png" alt="logo"></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-4 d-none d-lg-block">
                            <div class="header__search">
                                <form action="#">
                                    <div class="header__search-box">
                                        <input class="search-input" type="text" placeholder="I'm shopping for...">
                                        <button class="button" type="submit"><i class="far fa-search"></i></button>
                                    </div>
                                     <div class="header__search-cat">
                                        <select>
                                            <option>All Categories</option>
                                            <?php
                                            // Query to fetch categories from the 'Category' table
                                            $sql = "SELECT id, CategoryName FROM Category";
                                            $result = $conn->query($sql);
                                
                                            if ($result->num_rows > 0) {
                                                // Output data of each row
                                                while ($row = $result->fetch_assoc()) {
                                                    echo '<option value="' . $row['id'] . '">' . $row['CategoryName'] . '</option>';
                                                }
                                            } else {
                                                echo "No categories found";
                                            }
                                
                                           
                                            ?>
                                        </select>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-5 col-md-8 col-sm-8">
                            <div class="header-action">
                                <div class="block-userlink">
                                    <a class="icon-link" href="my-account.php">
                                    <i class="flaticon-user"></i>
                                    <span class="text">
                                    <span class="sub">Login </span>
                                    My Account </span>
                                    </a>
                                </div>
                                <div class="block-wishlist action" id="wishlist">
                                    <a class="icon-link" href="wishlist.php">
                                    <i class="flaticon-heart"></i>
                                    <?php
                                    // session_start();
                                    
                                    if (isset($_SESSION['user_id'])) {
                                        // User is logged in, so you can display the wishlist count
                                        if (isset($_SESSION['wishlist']) && is_array($_SESSION['wishlist'])) {
                                            $wishlistCount = count($_SESSION['wishlist']);
                                        } else {
                                            $wishlistCount = 0; // Wishlist is empty
                                        }
                                    } else {
                                        $wishlistCount = 0; // User is not logged in
                                    }
                                    ?>
                                    <span class="count"><?= $wishlistCount; ?></span>
                                    <span class="text">
                                    <span class="sub">Favorite</span>
                                    My Wishlist </span>
                                    </a>
                                </div>
                                <div class="block-cart action" id="cart">
                                    <a class="icon-link" href="cart.php">
                                        <i class="flaticon-shopping-bag"></i>
                                        <?php
                                        if (isset($_SESSION['user_id'])) {
                                            if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
                                                $cartItemCount = count($_SESSION['cart']);
                                                $totalPrice = 0;
                                    
                                                foreach ($_SESSION['cart'] as $cartItem) {
                                                    $totalPrice += $cartItem['Price'];
                                                }
                                    
                                                echo '<span class="count">' . $cartItemCount . '</span>';
                                                echo '<span class="text">';
                                                echo '<span class="sub">Your Cart:</span>';
                                                echo '$' . number_format($totalPrice, 2);
                                                echo '</span>';
                                            } else {
                                                echo '<span class="count">0</span>';
                                                echo '<span class="text">';
                                                echo '<span class="sub">Your Cart:</span>';
                                                echo '$0.00';
                                                echo '</span>';
                                            }
                                        } else {
                                            echo '<span class="count">0</span>';
                                            echo '<span class="text">Please log in to view your cart.</span>';
                                        }
                                        ?>
                                    </a>

                                    <div class="cart">
                                            <div class="cart__mini">
                                                <ul>
                                                    <li>
                                                        <div class="cart__title">
                                                            <h4>Your Cart</h4>
                                                            <?php
                                                            if (isset($_SESSION['user_id'])) {
                                                                if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
                                                                    echo '<span>(' . count($_SESSION['cart']) . ' Items in Cart)</span>';
                                                                } else {
                                                                    echo '<span>(0 Items in Cart)</span>';
                                                                }
                                                            } else {
                                                                echo '<span>(Not logged in)</span>';
                                                            }
                                                            ?>
                                                        </div>
                                                    </li>
                                        
                                                    <?php
                                                    // Check if the user is logged in
                                                    if (isset($_SESSION['user_id'])) {
                                                        // Check if the cart exists and is not empty
                                                        if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
                                                            $totalPrice = 0; // Initialize total price
                                        
                                                            foreach ($_SESSION['cart'] as $cartItem) {
                                                                // Assuming your cart items have 'ProductName', 'Price', and 'ProductMainImage' properties
                                                                $productName = $cartItem['ProductName'];
                                                                $price = $cartItem['Price'];
                                                                $productId = $cartItem['id'];
                                                                $productMainImage = $cartItem['ProductMainImage'];
                                        
                                                                $totalPrice += $price; // Calculate the total price
                                        
                                                                // Generate HTML for each cart item
                                                                echo '<li>
                                                                    <div class="cart__item d-flex justify-content-between align-items-center">
                                                                        <div class="cart__inner d-flex">
                                                                            <div class="cart__thumb">
                                                                                <a href="product-details.php">
                                                                                    <img src="./admin/uploads/' . $productMainImage . '" alt="">
                                                                                </a>
                                                                            </div>
                                                                            <div class="cart__details">
                                                                                <h6><a href="product-details.php">' . $productName . '</a></h6>
                                                                                <div class="cart__price">
                                                                                    <span>$' . $price . '</span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="cart__del">
                                                                            <a href="#" class="remove-from-cart" data-product-id="' . $productId . '"><i class="fal fa-times"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </li>';
                                                            }
                                        
                                                            // Display the subtotal and buttons
                                                            echo '<li>
                                                                <div class="cart__sub d-flex justify-content-between align-items-center">
                                                                    <h6>Subtotal</h6>
                                                                    <span class="cart__sub-total">$' . number_format($totalPrice, 2) . '</span>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <a href="cart.php" class="wc-cart mb-10">View cart</a>
                                                                
                                                            </li>';
                                                        } else {
                                                            // Display a message if the cart is empty
                                                            echo '<li><p>Your cart is empty.</p></li>';
                                                        }
                                                    } else {
                                                        // Display a message if the user is not logged in
                                                        echo '<li><p>Please log in to view your cart.</p></li>';
                                                    }
                                                    ?>
                                                    <!--<a href="checkout.php" class="wc-checkout">Checkout</a>-->
                                                </ul>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header__bottom">
            <div class="container">
                <div class="row g-0 align-items-center">
                    <div class="col-lg-3">                        
                        <div class="cat__menu-wrapper side-border d-none d-lg-block">
                            <div class="cat-toggle">
                                <button type="button" class="cat-toggle-btn cat-toggle-btn-1"><i class="fal fa-bars"></i> Shop by department</button>
                                <div class="cat__menu">
                                    <nav id="mobile-menu" style="display: block;">
                                        <ul>
                                            <li>
                                                <a>All Categories <i class="far fa-angle-down"></i></a>
                                                <ul class="submenu">
                                                    <?php
                                                    // Query to fetch categories from the 'Category' table
                                                    $sql = "SELECT id, CategoryName, slug FROM Category";
                                                    $result = $conn->query($sql);
                                    
                                                    if ($result->num_rows > 0) {
                                                        // Output data of each row
                                                        while ($row = $result->fetch_assoc()) {
                                                            echo '<li><a href="shop.php?slug='.$row['slug'].'">' . $row['CategoryName'] . '</a></li>';
                                                        }
                                                    } else {
                                                        echo "No categories found";
                                                    }
                                    
                                                    // Close the database connection
                                                    // $conn->close();
                                                    ?>
                                                </ul>
                                            </li>
                                        
                                            <li>
                                                <a>Services <i class="far fa-angle-down"></i></a>
                                                <ul class="submenu">
                                                    <?php
                                                    // Dynamic service pages menu items
                                                    $sql = "SELECT ServiceName, Slug FROM ServicePages";
                                                    $result = mysqli_query($conn, $sql);
                                        
                                                    if (mysqli_num_rows($result) > 0) {
                                                        while ($row = mysqli_fetch_assoc($result)) {
                                                            $service_name = $row["ServiceName"];
                                                            $slug = $row["Slug"];
                                                            echo '<li><a href="services.php?slug=' . $slug . '">' . $service_name . '</a></li>';
                                                        }
                                                    } else {
                                                        echo "No services found";
                                                    }
                                                    ?>
                                                </ul>
                                            </li>
                                        
                                            <li>
                                                <a>Pages <i class="far fa-angle-down"></i></a>
                                                <ul class="submenu">
                                                    <?php
                                                    // Dynamic content pages menu items
                                                    $contentPagesSql = "SELECT PageTitle, Slug FROM ContentPages";
                                                    $contentPagesResult = mysqli_query($conn, $contentPagesSql);
                                        
                                                    if (mysqli_num_rows($contentPagesResult) > 0) {
                                                        while ($contentRow = mysqli_fetch_assoc($contentPagesResult)) {
                                                            $page_title = $contentRow["PageTitle"];
                                                            $slug = $contentRow["Slug"];
                                                            echo '<li><a href="pages.php?slug=' . $slug . '">' . $page_title . '</a></li>';
                                                        }
                                                    } else {
                                                        echo "No pages found";
                                                    }
                                                    ?>
                                                </ul>
                                            </li>
                                        
                                            <li>
                                                <a>Support <i class="far fa-angle-down"></i></a>
                                                <ul class="submenu">
                                                    <?php
                                                    // Dynamic support pages menu items
                                                    $supportPagesSql = "SELECT PageTitle, Slug FROM SupportPages";
                                                    $supportPagesResult = mysqli_query($conn, $supportPagesSql);
                                        
                                                    if (mysqli_num_rows($supportPagesResult) > 0) {
                                                        while ($supportRow = mysqli_fetch_assoc($supportPagesResult)) {
                                                            $page_title = $supportRow["PageTitle"];
                                                            $slug = $supportRow["Slug"];
                                                            echo '<li><a href="support_pages.php?slug=' . $slug . '">' . $page_title . '</a></li>';
                                                        }
                                                    } else {
                                                        echo "No support pages found";
                                                    }
                                                    ?>
                                                </ul>
                                            </li>
                                            <!--<li>-->
                                            <!--    <a>Quick Links <i class="far fa-angle-down"></i></a>-->
                                            <!--    <ul class="submenu">-->
                                            <!--        <li><a href="my-account.php">My Account</a></li>-->
                                            <!--        <li><a href="faq.php">FAQ</a></li>-->
                                            <!--        <li><a href="cart.php">Cart</a></li>-->
                                            <!--        <li><a href="wishlist.php">Wishlist</a></li>-->
                                            <!--        <li><a href="404.php">404 Error</a></li>-->
                                            <!--    </ul>-->
                                            <!--</li>-->

                                        
                                            <?php
                                                    if (isset($_SESSION['user_id'])) {
                                                        echo '<li><a href="customer_dashboard.php">My Account</a></li>';
                                                    }
                                            ?>
                                            
                                            <?php
                                                    if (isset($_SESSION['user_id'])) {
                                                        echo '<li><a href="logout.php">Log Out</a></li>';
                                                    }
                                            ?>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-3">
                      <div class="header__bottom-left d-flex d-xl-block align-items-center">
                        <div class="side-menu d-lg-none mr-20">
                          <button type="button" class="side-menu-btn offcanvas-toggle-btn"><i class="fas fa-bars"></i></button>
                        </div>
                        <div class="main-menu d-none d-lg-block">
                            <nav>
                                <ul>
                                    <li><a href="index.php">Home</a></li>
                                    <li><a href="about.php">About Us</a></li>

                                    <?php

                                        $sql = "SELECT ServiceName, Slug FROM ServicePages";
                                        $result = mysqli_query($conn, $sql);
                                        
                                        // Check if there are results
                                        if (mysqli_num_rows($result) > 0) {
                                            echo '<li>';
                                            echo '<a href="#">Services <i class="far fa-angle-down"></i></a>';
                                            echo '<ul class="submenu">';
                                            
                                            while ($row = mysqli_fetch_assoc($result)) {
                                                $service_name = $row["ServiceName"];
                                                $slug = $row["Slug"];
                                                
                                                // Output each service as a list item with a link
                                                echo '<li><a href="services.php?slug=' . $slug . '">' . $service_name . '</a></li>';
                                            }
                                            
                                            echo '</ul>';
                                            echo '</li>';
                                        } 
                                        ?>
                                        
                                        <?php

                                            $contentPagesSql = "SELECT PageTitle, Slug FROM ContentPages";
                                            $contentPagesResult = mysqli_query($conn, $contentPagesSql);
                                            
                                            // Check if there are results
                                            if (mysqli_num_rows($contentPagesResult) > 0) {
                                                echo '<li>';
                                                echo '<a href="#">Pages<i class="far fa-angle-down"></i></a>';
                                                echo '<ul class="submenu">';
                                                
                                                while ($contentRow = mysqli_fetch_assoc($contentPagesResult)) {
                                                    $page_title = $contentRow["PageTitle"];
                                                    $slug = $contentRow["Slug"];
                                                    
                                                    // Output each page as a list item with a link
                                                    echo '<li><a href="pages.php?slug=' . $slug . '">' . $page_title . '</a></li>';
                                                }
                                                
                                                echo '</ul>';
                                                echo '</li>';
                                            } 
                                            // else {
                                            //     echo "No results found in the ContentPages table.";
                                            // }
                                        ?>

                                        <?php

                                            $supportPagesSql = "SELECT PageTitle, Slug FROM SupportPages";
                                            $supportPagesResult = mysqli_query($conn, $supportPagesSql);
                                            
                                            // Check if there are results
                                            if (mysqli_num_rows($supportPagesResult) > 0) {
                                                echo '<li>';
                                                echo '<a href="#">Support<i class="far fa-angle-down"></i></a>';
                                                echo '<ul class="submenu">';
                                                
                                                while ($supportRow = mysqli_fetch_assoc($supportPagesResult)) {
                                                    $page_title = $supportRow["PageTitle"];
                                                    $slug = $supportRow["Slug"];
                                                    
                                                    // Output each page as a list item with a link
                                                    echo '<li><a href="support_pages.php?slug=' . $slug . '">' . $page_title . '</a></li>';
                                                }
                                                
                                                echo '</ul>';
                                                echo '</li>';
                                            } 
                                            // else {
                                            //     echo "No results found in the ContentPages table.";
                                            // }
                                        ?>
                                    <!--<li><a href="logout.php">Log Out</a></li>-->
                                                                        <li><a href="contact.php">Contact Us</a></li>

                                </ul>
                            </nav>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-9">
                        <!--<div class="shopeing-text text-sm-end">-->
                        <!--    <p>Spend $120 more and get free shipping!</p>-->
                        <!--</div>-->
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- header-end -->
    
    <!-- offcanvas area start -->
    <div class="offcanvas__area">
        <div class="offcanvas__wrapper">
        <div class="offcanvas__close">
            <button class="offcanvas__close-btn" id="offcanvas__close-btn">
                <i class="fal fa-times"></i>
            </button>
        </div>
        <div class="offcanvas__content">
            <div class="offcanvas__logo mb-40">
                <a href="index.php">
                <img src="assets/img/logo/san6.png" alt="logo" style="width: 12em;">
                </a>
            </div>
            <div class="offcanvas__search mb-25">
                <form action="#">
                    <input type="text" placeholder="What are you searching for?">
                    <button type="submit" ><i class="far fa-search"></i></button>
                </form>
            </div>
            <div class="mobile-menu fix"></div>
            <div class="offcanvas__action">

            </div>
        </div>
        </div>
    </div>
    <!-- offcanvas area end -->      
    <div class="body-overlay"></div>
    <!-- offcanvas area end -->
    