<?php
include 'includes/header.php';
include 'includes/db_config.php';
?>
<?php
// Make sure to connect to your database

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize user inputs
    $currentPassword = mysqli_real_escape_string($conn, $_POST['currentPassword']);
    $newPassword = mysqli_real_escape_string($conn, $_POST['newPassword']);
    $confirmPassword = mysqli_real_escape_string($conn, $_POST['confirmPassword']);
    $user_id = $_SESSION['user_id'];

    // Check if the current password is correct
    $checkPasswordQuery = "SELECT Password FROM Customers WHERE id = $user_id";
    $result = mysqli_query($conn, $checkPasswordQuery);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $storedPassword = $row['Password'];

        if ($currentPassword === $storedPassword) {
            // Current password is correct
            if ($newPassword === $confirmPassword) {
                // Update the password in the Customers table
                $updatePasswordQuery = "UPDATE Customers SET Password = '$newPassword' WHERE id = $user_id";
                $updateResult = mysqli_query($conn, $updatePasswordQuery);

                if ($updateResult) {
                    echo '<script>';
                    echo 'alert("Password updated successfully!");';
                    echo '</script>';
                } else {
                    echo '<script>alert("Failed to update the password. Please try again.");</script>';
                }
            } else {
                // echo "New password and confirm password do not match.";
                 echo '<script>';
                    echo 'alert("New password and confirm password do not match.");';
                    echo '</script>';
            }
        } else {
            // echo "Current password is incorrect.";
            echo '<script>';
                    echo 'alert("Current password is incorrect.");';
                    echo '</script>';
        }
    } else {
        // echo "User not found or database error.";
        echo '<script>';
                    echo 'alert("User not found or database error.");';
                    echo '</script>';
    }
}
?>
     <!-- header-end -->

    

    <main>
        <!-- page-banner-area-start -->
        <div class="page-banner-area page-banner-height-2" data-background="assets/img/banner/page_content.png">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="page-banner-content text-center">
                            <h4 class="breadcrumb-title">My Orders</h4>
                            <div class="breadcrumb-two">
                                <nav>
                                   <nav class="breadcrumb-trail breadcrumbs">
                                      <ul class="breadcrumb-menu">
                                         <li class="breadcrumb-trail">
                                            <a href="index.php"><span>Home</span></a>
                                         </li>
                                         <li class="trail-item">
                                            <span>My Orders</span>
                                         </li>
                                      </ul>
                                   </nav> 
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- page-banner-area-end -->

        <!-- cart-area-start -->
        <section class="cart-area pb-120 pt-120">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-4 col-sm-12">
                        <div class="customer-sidebar">
                            <h4 class="text-center">My Account</h4>
                            <div class="list-group">
                                <a href="javascript:void(0);" data-target="orders-table" class="list-group-item list-group-item-action">Orders</a>
                                <a href="javascript:void(0);" data-target="profile-table" class="list-group-item list-group-item-action">Profile</a>
                                <a href="javascript:void(0);" data-target="settings-table" class="list-group-item list-group-item-action">Settings</a>
                                <a href="logout.php"  class="list-group-item list-group-item-action">Log Out</a>
                                <!-- Add more links with different data-target values -->
                            </div>
                        </div>
                    </div>

                     <div class="cont col-lg-9 col-md-8 col-sm-12" id="orders-table" style="display: none">
                        <div class="card">
                        
                            <div class="table-content table-responsive card-body" style="margin-top: 29px; max-height: 400px; overflow-y: auto;">
                                <h2 class="card-title text-center">My Orders</h2>
                                <?php
                                    $user_id = $_SESSION['user_id'];
                                
                                    $sql = "SELECT oi.id, oi.user_id, oi.order_id, oi.prod_id, oi.qty, oi.price, oi.created_at, p.ProductMainImage, o.Status
                                            FROM order_items oi
                                            JOIN Product p ON oi.prod_id = p.id
                                            JOIN Orders o ON oi.user_id = o.CustomerID
                                            WHERE oi.user_id = $user_id";
                                            
                                    $result = mysqli_query($conn, $sql);
                                    
                                    if (mysqli_num_rows($result) > 0) {
                                        echo '<table class="table">';
                                        echo '<thead>';
                                        echo '<tr>';
                                        echo '<th class="product-order">Order ID</th>';
                                        echo '<th class="product-thumbnail">Image</th>';
                                        echo '<th class="cart-product-name">Product</th>';
                                        echo '<th class="product-price">Unit Price</th>';
                                        echo '<th class="product-quantity">Quantity</th>';
                                        echo '<th class="product-subtotal">Total</th>';
                                        echo '<th class="product-remove">Status</th>';
                                        echo '</tr>';
                                        echo '</thead>';
                                        echo '<tbody>';
                                    
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            
                                            echo '<tr>';
                                            echo '<td class="product-order">' . $row['order_id'] . '</td>';
                                            echo '<td class="product-thumbnail"><img src="./admin/uploads/' . $row['ProductMainImage'] . '" alt=""></td>';
                                            echo '<td class="cart-product-name">Product Name</td>'; // You can replace this with the actual product name
                                            echo '<td class="product-price"><span class="amount">$' . $row['price'] . '</span></td>';
                                            echo '<td class="product-quantity">' . $row['qty'] . '</td>';
                                            echo '<td class="product-subtotal"><span class="amount">$' . ($row['price'] * $row['qty']) . '</span></td>';
                                            echo '<td class="product-remove">';
                                            if ($row['Status'] == 0) {
                                                echo 'Pending';
                                            } elseif ($row['Status'] == 1) {
                                                echo 'Accepted';
                                            } else {
                                                echo 'Unknown Status';
                                            }
                                            echo '</td>'; // You can replace this with the actual status
                                            echo '</tr>';

                                        }
                                    
                                        echo '</tbody>';
                                        echo '</table>';
                                    } else {
                                        echo "No records found.";
                                    }
                                    
                                    // Close the database connection
                                    // mysqli_close($conn);
                                    
                                    ?>

                            </div>
                        
                    </div>
                    </div>
                    
                     <div class="cont col-lg-9 col-md-8 col-sm-12" id="profile-table" style="display: none">
                        <div class="container mt-5">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php
                                    // Fetch customer data (assuming you have a user ID)
                                    // $user_id = $_SESSION['user_id'];
                                    $sql1 = "SELECT Name, Email, PhoneNumber, Address, City, ZipCode, State, Country FROM Customers WHERE id = $user_id";
                                    $result1 = mysqli_query($conn, $sql1);
                    
                                    if (mysqli_num_rows($result1) > 0) {
                                        $row1 = mysqli_fetch_assoc($result1);
                                        ?>
                    
                                        <div class="card">
                                            <div class="card-body">
                                                <h3 class="card-title"><?php echo $row1['Name']; ?></h3>
                                                <p class="card-text"><strong>Email:</strong> <?php echo $row1['Email']; ?></p>
                                                <p class="card-text"><strong>Mobile:</strong> <?php echo $row1['PhoneNumber']; ?></p>
                                                <p class="card-text"><strong>Address:</strong> <?php echo $row1['Address']; ?></p>
                                                <p class="card-text"><strong>City:</strong> <?php echo $row1['City']; ?></p>
                                                <p class="card-text"><strong>Zip Code:</strong> <?php echo $row1['ZipCode']; ?></p>
                                                <p class="card-text"><strong>State:</strong> <?php echo $row1['State']; ?></p>
                                                <p class="card-text"><strong>Country:</strong> <?php echo $row1['Country']; ?></p>
                                            </div>
                                        </div>
                                    <?php
                                    } else {
                                        echo "No customer data found.";
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="cont col-lg-9 col-md-8 col-sm-12" id="settings-table" style="display: none">
                        <div class="card">
                            <div class="card-header">
                                Update Password
                            </div>
                            <div class="card-body">
                                    <form action="#" method="POST">
                                        <div class="form-group">
                                            <label for="currentPassword">Current Password</label>
                                            <input type="password" class="form-control" id="currentPassword" name="currentPassword" placeholder="Enter current password">
                                        </div>
                                        <div class="form-group">
                                            <label for="newPassword">New Password</label>
                                            <input type="password" class="form-control" id="newPassword" name="newPassword" placeholder="Enter new password">
                                        </div>
                                        <div class="form-group">
                                            <label for="confirmPassword">Confirm New Password</label>
                                            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" placeholder="Confirm new password">
                                        </div>
                                        <button type="submit" class="btn btn-primary">Update Password</button>
                                    </form>
    </div>
                        </div>

                    </div>

                    
                </div>
            </div>
        </section>
         <!-- cart-area-end -->

        <!-- brand-area-start -->
        <?php include 'includes/brands.php';  ?>
        <!-- brand-area-end -->
        

    </main>
    
   <script>
    var listGroupItems = document.querySelectorAll(".list-group-item");
    var contentContainers = document.querySelectorAll(".cont");

    listGroupItems.forEach(function (item, index) {
        item.addEventListener("click", function () {
            contentContainers.forEach(function (container, containerIndex) {
                if (containerIndex === index) {
                    container.style.display = "block";
                } else {
                    container.style.display = "none";
                }
            });
        });
    });
</script>

<script>
    function validatePassword() {
        var newPassword = document.getElementById("newPassword").value;
        var confirmPassword = document.getElementById("confirmPassword").value;

        if (newPassword !== confirmPassword) {
            var alertMessage = document.getElementById("alertMessage");
            alertMessage.innerHTML = '<div class="alert alert-danger" role="alert">New password and confirm password do not match.</div>';
            return false; // Prevent form submission
        }

        return true; // Allow form submission if passwords match
    }
</script>



    <!-- footer-start -->
    <?php
include 'includes/footer.php';
?>