<?php
include 'includes/header.php';

// Check if the cart array exists in the session
if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {
    $cart = $_SESSION['cart'];
    // You have cart data available in the $cart array
}
?>
     <!-- header-end -->

    

    <main>
        <!-- page-banner-area-start -->
        <div class="page-banner-area page-banner-height-2" data-background="assets/img/banner/page_content.png">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="page-banner-content text-center">
                            <h4 class="breadcrumb-title">Your Cart</h4>
                            <div class="breadcrumb-two">
                                <nav>
                                   <nav class="breadcrumb-trail breadcrumbs">
                                      <ul class="breadcrumb-menu">
                                         <li class="breadcrumb-trail">
                                            <a href="index.php"><span>Home</span></a>
                                         </li>
                                         <li class="trail-item">
                                            <span>Cart</span>
                                         </li>
                                      </ul>
                                   </nav> 
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- page-banner-area-end -->

        <!-- cart-area-start -->
        <section class="cart-area pt-120 pb-120">
            <div class="container">
               <div class="row">
                  <div class="col-12">
                        <form action="checkout.php" method="POST">
                           <div class="table-content table-responsive">
                              <table class="table" id="cart_table">
                                <thead>
                                    <tr>
                                        <th class="product-thumbnail">Images</th>
                                        <th class="cart-product-name">Product</th>
                                        <th class="product-price">Unit Price</th>
                                        <th class="product-quantity">Quantity</th>
                                        <th class="product-subtotal">Total</th>
                                        <th class="product-remove">Remove</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (isset($_SESSION['user_id']) && !empty($cart)) {
                                        foreach ($cart as $product) {
                                    ?>
                                    <tr>
                                        <td class="product-thumbnail">
                                            <a href="shop-details.php">
                                                <img src="./admin/uploads/<?php echo $product['ProductMainImage']; ?>" alt="">
                                            </a>
                                        </td>
                                        <td class="product-name">
                                            <a href="shop-details.php"><?php echo $product['ProductName']; ?></a>
                                        </td>
                                        <td class="product-price"><span class="amount">Rs. <?php echo $product['Price']; ?></span></td>
                                        <td class="product-quantity">
                                            <div class="cart-plus-minus">
                                                <input type="text" class="quantity-input" name="quantity[<?php echo $product['id']; ?>]" value="<?php echo $product['quantity']; ?>" data-product-id="<?php echo $product['id']; ?>">
                                                <div class="dec qtybutton" data-type="dec">-</div>
                                                <div class="inc qtybutton" data-type="inc">+</div>
                                            </div>
                                        </td>
                                        <td class="product-subtotal"><span class="amount">Rs. <?php echo $product['Price'] * $product['quantity']; ?></span></td>
                                        <td class="product-remove">
                                            <a href="#" class="remove-from-cart" data-product-id="<?php echo $product['id']; ?>"><i class="fa fa-times"></i></a>
                                        </td>
                                    </tr>
                                    <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="6">No products in the cart.</td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                           </div>
                           <div class="row">
                              <div class="col-12">
                                    <div class="coupon-all">
                                       <div class="coupon">
                                          <input id="coupon_code" class="input-text" name="coupon_code" value="" placeholder="Coupon code" type="text">
                                          <button class="tp-btn-h1" name="apply_coupon" type="submit">Apply
                                                coupon</button>
                                       </div>
                                       <!--<div class="coupon2">-->
                                       <!--   <button class="tp-btn-h1" name="update_cart" type="submit">Update cart</button>-->
                                       <!--</div>-->
                                    </div>
                              </div>
                           </div>
                           <div class="row justify-content-end">
                              <div class="col-md-5">
                                    <div class="cart-page-total">
                                        <h2>Cart totals</h2>
                                        <ul class="mb-20">
                                            <li>Subtotal <span id="cart-subtotal-amount">Rs. 0.00</span></li>
                                            <li>Total <span id="cart-total-amount">Rs. 0.00</span></li>
                                            <input type="hidden" name="cart_subtotal" id="cart-subtotal-input" value="">
                                            <input type="hidden" name="cart_total" id="cart-total-input" value="">
                                        </ul>
                                        <button type="submit" class="tp-btn-h1">Proceed to checkout</button>
                                    </div>
                              </div>
                           </div>
                        </form>
                  </div>
               </div>
            </div>
         </section>
         <!-- cart-area-end -->

        <!-- cta-area-start -->
       <!-- <section class="cta-area d-ldark-bg pt-55 pb-10">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item cta-item-d mb-30">
                            <h5 class="cta-title">Follow Us</h5>
                            <p>We make consolidating, marketing and tracking your social media website easy.</p>
                            <div class="cta-social">
                                <div class="social-icon">
                                    <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#" class="twitter"><i class="fab fa-twitter"></i></a>
                                    <a href="#" class="youtube"><i class="fab fa-youtube"></i></a>
                                    <a href="#" class="linkedin"><i class="fab fa-linkedin-in"></i></a>
                                    <a href="#" class="rss"><i class="fas fa-rss"></i></a>
                                    <a href="#" class="dribbble"><i class="fab fa-dribbble"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item mb-30">
                            <h5 class="cta-title">Sign Up To Newsletter</h5>
                            <p>Join 60.000+ subscribers and get a new discount coupon  on every Saturday.</p>
                            <div class="subscribe__form">
                                <form action="#">
                                    <input type="email" placeholder="Enter your email here...">
                                    <button>subscribe</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="cta-item mb-30">
                            <h5 class="cta-title">Download App</h5>
                            <p>DukaMarket App is now available on App Store & Google Play. Get it now.</p>
                            <div class="cta-apps">
                                <div class="apps-store">
                                    <a href="#"><img src="assets/img/brand/app_ios.png" alt=""></a>
                                    <a href="#"><img src="assets/img/brand/app_android.png" alt=""></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>-->
        <!-- cta-area-end -->

    </main>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    


<script>
$(document).ready(function () {
    updateCartTotal();

    // Listen for changes in the quantity input fields
    $(".cart-plus-minus .qtybutton").on("click", function () {
        var input = $(this).siblings("input");
        var quantity = parseInt(input.val());

        var type = $(this).data("type");
        if (type === "inc") {
            quantity += 1;
        } else if (type === "dec" && quantity > 1) {
            quantity -= 1;
        }

        // Ensure the quantity doesn't go below 1
        if (quantity < 1) {
            quantity = 1;
        }

        input.val(quantity); // Update the input field with the new quantity
        updateSubtotal(input);
    });

    // Update subtotal for a specific row
    function updateSubtotal(input) {
        const row = $(input).closest("tr");
        const price = parseFloat(row.find(".product-price span").text().replace("Rs. ", ""));
        const quantity = parseInt(input.val());
        const subtotal = price * quantity;
        row.find(".product-subtotal .amount").text("Rs. " + subtotal.toFixed(2)); // Update the subtotal on the page

        updateCartTotal(); // Update the total cart price
    }

    // Update the total cart price and populate hidden input fields
    function updateCartTotal() {
        var total = 0;
        $(".product-subtotal .amount").each(function () {
            var subtotal = parseFloat($(this).text().replace("Rs. ", ""));
            total += subtotal;
        });

        // Update both the subtotal and total amounts displayed on the page
        $("#cart-subtotal-amount").text("Rs. " + total.toFixed(2));
        $("#cart-total-amount").text("Rs. " + total.toFixed(2));

        // Populate the hidden input fields with the calculated values
        $("#cart-subtotal-input").val(total.toFixed(2));
        $("#cart-total-input").val(total.toFixed(2));
    }
});
</script>

<script>
$(document).ready(function () {
    // Attach a click event handler to "Remove" links in the cart
    $(".remove-from-cart").on("click", function (e) {
        e.preventDefault();

        // Get the product ID from the data attribute
        var productId = $(this).data("product-id");

        // Find the product in the displayed list and remove it
        var $productRow = $(".cart-item[data-product-id='" + productId + "']");
        
        // Remove the product from the displayed list
        $productRow.remove();

        // Send an AJAX request to remove the product from the cart
        $.ajax({
            type: "POST",
            url: "remove_from_cart.php", // URL to handle removal
            data: { product_id: productId },
            success: function (response) {
                // Log the response to the console for debugging
                console.log(response);

                if (response.message === "Product removed from cart") {
                    // Product removal was successful
                    location.reload();
                } else if (response.message === "Product not found in cart") {
                    // Product not found in cart; you may choose to ignore or log this message
                    // You can comment out or remove this alert
                } else {
                    // Handle other errors
                   //  alert("Failed to remove product from cart: " + response.message);
                    
                    // Since the server-side removal failed, you may consider adding the item back to the displayed list
                    // $cartContainer.append($productRow); // Uncomment this line if needed
                }
            },
            dataType: "json" // Specify that you expect a JSON response
        });
    });
});

</script>




    <!-- footer-start -->
    <?php
include 'includes/footer.php';
?>
