<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");


?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Products</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Products</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Product List</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="productTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Product Code</th>
                                        <th>Category</th>
                                        <th>Status</th>
                                        <th>Avail.</th>
                                        <th>Price</th>
                                        <th>Image</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Assuming you have a database connection in db_config.php
                                    $query = "SELECT id, ProductName, ProductCode, ProductCategories, status, Availability, Price, ProductMainImage FROM Product";
                                    $result = mysqli_query($conn, $query);

                                    while ($row = mysqli_fetch_assoc($result)) {
                                        echo "<tr>";
                                        echo "<td>{$row['id']}</td>";
                                        echo "<td>{$row['ProductName']}</td>";
                                        echo "<td>{$row['ProductCode']}</td>";
                                        echo "<td>{$row['ProductCategories']}</td>";
                                        echo "<td>{$row['status']}</td>";
                                        echo "<td>{$row['Availability']}</td>";
                                        echo "<td>{$row['Price']}</td>";
                                        echo "<td><img src='uploads/{$row['ProductMainImage']}' alt='Product Image' style='height: 6em;'></td>";
                                        echo "<td><a href='edit_product.php?id={$row['id']}' class='btn btn-primary'>Edit</a>
                                              <a href='delete.php?delete_id={$row['id']}&table=Product' class='btn btn-danger'>Delete</a></td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Product Code</th>
                                        <th>Category</th>
                                        <th>Status</th>
                                        <th>Avail.</th>
                                        <th>Price</th>
                                        <th>Image</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>

<?php include("./includes/footer.php");
}
?>
