<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    
        $servicePageId = $_GET['id'];

        // Retrieve the existing service page information based on the ID using prepared statement
        $sql = "SELECT * FROM ServicePages WHERE id = ?";
        
        // Use prepared statement
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 'i', $servicePageId);
        
        $result = mysqli_stmt_execute($stmt);

        if ($result) {
            $result = mysqli_stmt_get_result($stmt);
            if (mysqli_num_rows($result) == 1) {
                $servicePageData = mysqli_fetch_assoc($result);
            }
        }

        // Close the statement
       /* mysqli_stmt_close($stmt);*/
    

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['ServiceName']) && isset($_POST['PageContent'])) {
            $serviceName = $_POST['ServiceName'];
            $pageContent = $_POST['PageContent'];

            // Validate and sanitize input
            $serviceName = htmlspecialchars(strip_tags($serviceName));

            // For HTML content, you can store it as is without additional sanitation
            $pageContent = $_POST['PageContent'];

            function generateSlug($text) {
                $text = strtolower(str_replace(" ", "-", $text));
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($serviceName);

            // Handle the uploaded banner image
            $bannerUploadPath = $servicePageData['Banner'];

            if (isset($_FILES['Banner']['name']) && !empty($_FILES['Banner']['name'])) {
                // Remove the old banner image if it exists
                if (file_exists($servicePageData['Banner'])) {
                    unlink($servicePageData['Banner']);
                }

                // Upload and update the new banner image
                $bannerUploadPath = 'Banners/' . basename($_FILES['Banner']['name']);
                if (move_uploaded_file($_FILES['Banner']['tmp_name'], $bannerUploadPath)) {
                    // Banner image uploaded successfully
                } else {
                    echo '<script>alert("Failed to upload the banner image.");</script>';
                }
            }

            // Update the service page information in the database using prepared statement
            $sql = "UPDATE ServicePages SET ServiceName = ?, Banner = ?, PageContent = ?, Slug = ? WHERE id = ?";
            
            // Use prepared statement
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, 'ssssi', $serviceName, $bannerUploadPath, $pageContent, $slug, $servicePageId);

            // Execute the statement
            $result = mysqli_stmt_execute($stmt);

            if ($result) {
                echo '<script>alert("Service Page Updated");</script>';
            } else {
                // Display an error message
                echo "Error: " . mysqli_stmt_error($stmt);
            }

            // Close the statement
            mysqli_stmt_close($stmt);
        }
    }

?>



<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit Service Page</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Edit Service Page</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Service Page Information</h3>
                        </div>
                        <form method="POST" enctype="multipart/form-data">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="ServiceName">Service Name</label>
                                    <input type="text" class="form-control" id="ServiceName" name="ServiceName" required value="<?php echo $servicePageData['ServiceName']; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="Banner">Banner Image</label>
                                    <?php
                                    if (!empty($servicePageData['Banner']) && file_exists($servicePageData['Banner'])) {
                                        echo '<img src="' . $servicePageData['Banner'] . '" alt="Existing Banner" style="max-width: 200px;"><br>';
                                    }
                                    ?>
                                    <input type="file" class="form-control-file" id="Banner" name="Banner" accept="image/*">
                                </div>
                                <div class="form-group">
                                    <label for="PageContent">Page Content</label>
                                    <textarea class="form-control" id="PageContent" name="PageContent" rows="5" required><?php echo $servicePageData['PageContent']; ?></textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Update Service Page</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include("./includes/footer.php"); ?>

<?php
}
?>
