<?php
include("./includes/db_config.php");
error_reporting(E_ALL);
ini_set('display_errors', '1');
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

        $productData = [];

   
        $id = $_GET["id"];
        $selectSql = "SELECT * FROM Product WHERE id = $id";
        $result = $conn->query($selectSql);

        if ($result->num_rows == 1) {
            $productData = $result->fetch_assoc();
        }
    

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Retrieve form data
        $productName = $_POST["ProductName"];
        $productCode = $_POST["ProductCode"];
        $productCategories = $_POST["ProductCategories"];
        $availability = $_POST["Availability"];
        $price = $_POST["Price"];
        $description = $_POST["Description"];
        $shortDescription = $_POST["ShortDescription"];
        $status = $_POST["Status"];
        function generateSlug($text) {
                // Replace spaces with hyphens and make the text lowercase
                $text = strtolower(str_replace(" ", "-", $text));
                // Remove any characters that are not letters, numbers, or hyphens
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($productName);

        // Handle the product main image upload
        if ($_FILES["ProductMainImage"]["error"] === 0) {
            $mainImageFileName = $_FILES["ProductMainImage"]["name"];
            $mainImageTmpName = $_FILES["ProductMainImage"]["tmp_name"];
            move_uploaded_file($mainImageTmpName, "uploads/$mainImageFileName");

            // Delete the old main image if it exists
            if (file_exists("uploads/" . $productData["ProductMainImage"])) {
                unlink("uploads/" . $productData["ProductMainImage"]);
            }
        } else {
            $mainImageFileName = $productData["ProductMainImage"];
        }

        // Handle the additional images upload
        $additionalImageNames = array();
        if (isset($_FILES["AdditionalImages"]["name"])) {
            $additionalImagesCount = count($_FILES["AdditionalImages"]["name"]);
            for ($i = 0; $i < $additionalImagesCount; $i++) {
                if ($_FILES["AdditionalImages"]["error"][$i] === 0) {
                    $additionalImageFileName = $_FILES["AdditionalImages"]["name"][$i];
                    $additionalImageTmpName = $_FILES["AdditionalImages"]["tmp_name"][$i];
                    move_uploaded_file($additionalImageTmpName, "uploads/$additionalImageFileName");
                    $additionalImageNames[] = $additionalImageFileName;
                }
            }
        }

        // Combine existing and new additional images
        $existingAdditionalImages = explode(",", $productData["AdditionalImages"]);
        $additionalImageNames = array_merge($existingAdditionalImages, $additionalImageNames);

        // Update data in the 'Product' table using SQL
        $updateSql = "UPDATE Product SET ProductName = '$productName', slug = '$slug', ProductCode = '$productCode', ProductCategories = '$productCategories', Availability = '$availability', Price = $price, Description = '$description', ProductMainImage = '$mainImageFileName', AdditionalImages = '" . implode(',', $additionalImageNames) . "', ShortDescription = '$shortDescription', status = '$status' WHERE id = $id";

        if ($conn->query($updateSql) === TRUE) {
            // Data updated successfully
            echo '<script>alert("Data updated successfully.");</script>';
        } else {
            // Error handling
            echo '<script>alert("Error updating data: ' . $conn->error . '");</script>';
        }
    }
}
?>


<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit Products</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Edit Product</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Product Information</h3>
                        </div>
                        <form method="POST" enctype="multipart/form-data">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="ProductName">Product Name</label>
                                    <input type="text" class="form-control" id="ProductName" name="ProductName" required value="<?php echo $productData["ProductName"]; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="ProductCode">Product Code</label>
                                    <input type="text" class="form-control" id="ProductCode" name="ProductCode" required value="<?php echo $productData["ProductCode"]; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="ProductCategories">Product Categories</label>
                                    <select class="form-control" id="ProductCategories" name="ProductCategories">
                                        <option value="Category1" <?php if ($productData["ProductCategories"] == "Category1") echo "selected"; ?>>Category 1</option>
                                        <option value="Category2" <?php if ($productData["ProductCategories"] == "Category2") echo "selected"; ?>>Category 2</option>
                                        <option value="Category3" <?php if ($productData["ProductCategories"] == "Category3") echo "selected"; ?>>Category 3</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="Availability">Availability</label>
                                    <select class="form-control" id="Availability" name="Availability">
                                        <option value="InStock" <?php if ($productData["Availability"] == "InStock") echo "selected"; ?>>In Stock</option>
                                        <option value="OutOfStock" <?php if ($productData["Availability"] == "OutOfStock") echo "selected"; ?>>Out Of Stock</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="Price">Price</label>
                                    <input type="number" class="form-control" id="Price" name="Price" required value="<?php echo $productData["Price"]; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="Description">Description</label>
                                    <textarea class="form-control" id="description" name="Description" rows="4" required><?php echo $productData["Description"]; ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="ProductMainImage">Product Main Image</label>
                                    <?php
                                    if (!empty($productData["ProductMainImage"])) {
                                        echo '<img src="uploads/' . $productData["ProductMainImage"] . '" alt="Main Image" class="img-thumbnail" style="max-width: 100px;"><br>';
                                    }
                                    ?>
                                    <input type="file" class="form-control-file" id="ProductMainImage" name="ProductMainImage">
                                    <label class="form-control-label" for="ProductMainImage">Choose file</label>
                                </div>
                                <div class="form-group">
                                    <label for="AdditionalImages">Additional Images</label>
                                    <?php
                                    if (!empty($productData["AdditionalImages"])) {
                                        $additionalImages = explode(',', $productData["AdditionalImages"]);
                                        foreach ($additionalImages as $image) {
                                            echo '<img src="uploads/' . $image . '" alt="Additional Image" class="img-thumbnail" style="max-width: 100px;"><br>';
                                        }
                                    }
                                    ?>
                                    <input type="file" class="form-control-file" id="AdditionalImages" name="AdditionalImages[]" multiple>
                                    <label class="form-control-label" for="AdditionalImages">Choose files</label>
                                </div>
                                <div class="form-group">
                                    <label for="ShortDescription">Short Description</label>
                                    <textarea class="form-control" id="ShortDescription" name="ShortDescription" rows="2"><?php echo $productData["ShortDescription"]; ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Status</label>
                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" id="Published" name="Status" value="Published" <?php if ($productData["status"] == "Published") echo "checked"; ?>>
                                        <label class="form-check-label" for="Published">Published</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" id="Draft" name="Status" value="Draft" <?php if ($productData["status"] == "Draft") echo "checked"; ?>>
                                        <label class="form-check-label" for="Draft">Draft</label>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>


<?php include("./includes/footer.php"); ?>
