<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    $contentPageData = [];

    
        $contentPageId = $_GET['id'];

        // Retrieve the existing content page information based on the ID
        $sql = "SELECT * FROM ContentPages WHERE id = ?";
        
        // Use prepared statement
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, 'i', $contentPageId);
        
        $result = mysqli_stmt_execute($stmt);

        if ($result) {
            $result = mysqli_stmt_get_result($stmt);
            if (mysqli_num_rows($result) == 1) {
                $contentPageData = mysqli_fetch_assoc($result);
            }
        }

        // Close the statement
    

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['PageTitle']) && isset($_POST['PageContent'])) {
            $pageTitle = $_POST['PageTitle'];
            $pageContent = $_POST['PageContent'];

            // Validate and sanitize input
            $pageTitle = htmlspecialchars(strip_tags($pageTitle));

            // For HTML content, you can store it as is without additional sanitation
            $pageContent = $_POST['PageContent'];

            function generateSlug($text) {
                $text = strtolower(str_replace(" ", "-", $text));
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($pageTitle);

            // Update the content page information in the database using prepared statement
            $sql = "UPDATE ContentPages SET PageTitle = ?, PageContent = ?, Slug = ? WHERE id = ?";
            
            // Use prepared statement
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, 'sssi', $pageTitle, $pageContent, $slug, $contentPageId);

            // Execute the statement
            $result = mysqli_stmt_execute($stmt);

            if ($result) {
                echo '<script>alert("Content Page Updated");</script>';
            } else {
                // Display an error message
                echo "Error: " . mysqli_stmt_error($stmt);
            }

            // Close the statement
            mysqli_stmt_close($stmt);
        }
    }

?>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit Content Page</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Edit Content Page</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class "content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Content Page Information</h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="PageTitle">Page Title</label>
                                    <input type="text" class="form-control" id="PageTitle" name="PageTitle" required value="<?php echo $contentPageData['PageTitle']; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="PageContent">Page Content</label>
                                    <textarea class="form-control" id="PageContent" name="PageContent" rows="5" required><?php echo $contentPageData['PageContent']; ?></textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Update Content Page</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include("./includes/footer.php"); ?>
<?php
}
?>
