<?php 
 include("./includes/db_config.php"); 
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");


// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve the header and footer code from the form
    $headerCode = $_POST["HeaderCode"];
    $footerCode = $_POST["FooterCode"];

    $sql = "UPDATE HeaderFooterCode SET HeaderCode = ?, FooterCode = ? WHERE id = 1";

    // Use prepared statements to prevent SQL injection
    $stmt = mysqli_prepare($conn, $sql);

    // Bind the parameters
    mysqli_stmt_bind_param($stmt, "ss", $headerCode, $footerCode);

    // Execute the statement
    if (mysqli_stmt_execute($stmt)) {
        echo "Record updated successfully.";
    } else {
        echo "Error updating record: " . mysqli_error($conn);
    }

    // Close the statement and database connection
    mysqli_stmt_close($stmt);
    mysqli_close($conn);
}
?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Header and Footer Code</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Header and Footer Code</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Header and Footer Code</h3>
                        </div>
                        <form method="POST" id="headerCodeForm" action="">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="HeaderCode">Header Code</label>
                                    <textarea class="form-control" id="HeaderCode" name="HeaderCode" rows="6"></textarea>
                                </div>
                            </div>
                                             <div class="card-body">
                                <div class="form-group">
                                    <label for="FooterCode">Footer Code</label>
                                    <textarea class="form-control" id="FooterCode" name="FooterCode" rows="6"></textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save Code</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
</div>

<?php include("./includes/footer.php");

}
?>
