<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (
            isset($_POST['ServiceName']) &&
            isset($_FILES['Banner']['name']) &&
            isset($_POST['PageContent'])
        ) {
            $serviceName = $_POST['ServiceName'];
            $pageContent = $_POST['PageContent'];

            // Validate and sanitize input
            $serviceName = htmlspecialchars(strip_tags($serviceName));

            // For HTML content, you can store it as is without additional sanitation
            $pageContent = $_POST['PageContent'];

            function generateSlug($text) {
                $text = strtolower(str_replace(" ", "-", $text));
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }

            $slug = generateSlug($serviceName);

            // Handle the uploaded banner image
            $bannerUploadPath = 'Banners/' . basename($_FILES['Banner']['name']);
            if (move_uploaded_file($_FILES['Banner']['tmp_name'], $bannerUploadPath)) {

                // Use prepared statement to insert data into the database
                $sql = "INSERT INTO ServicePages (ServiceName, Banner, PageContent, Slug) VALUES (?, ?, ?, ?)";

                // Use prepared statement
                $stmt = mysqli_prepare($conn, $sql);

                if ($stmt) {
                    // Bind parameters
                    mysqli_stmt_bind_param($stmt, 'ssss', $serviceName, $bannerUploadPath, $pageContent, $slug);

                    // Execute the statement
                    $result = mysqli_stmt_execute($stmt);

                    if ($result) {
                        echo '<script>alert("Service Page Added");</script>';
                    } else {
                        // Display an error message
                        echo "Error: " . mysqli_stmt_error($stmt);
                    }

                    // Close the statement
                    mysqli_stmt_close($stmt);
                } else {
                    // Display an error message
                    echo "Error: " . mysqli_error($conn);
                }
            } else {
                echo '<script>alert("Failed to upload the banner image.");</script>';
            }
        }
    }

?>



<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add Service Page</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Add Service Page</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Service Page Information</h3>
                        </div>
                        <form method="POST" enctype="multipart/form-data">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="ServiceName">Service Name</label>
                                    <input type="text" class="form-control" id="ServiceName" name="ServiceName" required>
                                </div>
                                <div class="form-group">
                                    <label for="Banner">Banner Image</label>
                                    <input type="file" class="form-control-file" id="Banner" name="Banner" accept="image/*" required>
                                </div>
                                <div class="form-group">
                                    <label for="PageContent">Page Content</label>
                                    <textarea class="form-control" id="PageContent" name="PageContent" rows="5" required></textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Service Page</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>


<?php include("./includes/footer.php");

}
?>
