<?php 
 include("./includes/db_config.php"); 
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");
    
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $productName = $_POST["ProductName"];
    $productCode = $_POST["ProductCode"];
    $productCategories = $_POST["ProductCategories"];
    $availability = $_POST["Availability"];
    $price = $_POST["Price"];
    $description = $_POST["Description"];
    $shortDescription = $_POST["ShortDescription"];
    $status = $_POST["Status"];
            function generateSlug($text) {
                // Replace spaces with hyphens and make the text lowercase
                $text = strtolower(str_replace(" ", "-", $text));
                // Remove any characters that are not letters, numbers, or hyphens
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($productName);

    // Handle the product main image upload
    if ($_FILES["ProductMainImage"]["error"] === 0) {
        $mainImageFileName = $_FILES["ProductMainImage"]["name"];
        $mainImageTmpName = $_FILES["ProductMainImage"]["tmp_name"];
        move_uploaded_file($mainImageTmpName, "uploads/$mainImageFileName");
    }

    // Handle the additional images upload
    $additionalImageNames = array();
    if (isset($_FILES["AdditionalImages"]["name"])) {
        $additionalImagesCount = count($_FILES["AdditionalImages"]["name"]);
        for ($i = 0; $i < $additionalImagesCount; $i++) {
            if ($_FILES["AdditionalImages"]["error"][$i] === 0) {
                $additionalImageFileName = $_FILES["AdditionalImages"]["name"][$i];
                $additionalImageTmpName = $_FILES["AdditionalImages"]["tmp_name"][$i];
                move_uploaded_file($additionalImageTmpName, "uploads/$additionalImageFileName");
                $additionalImageNames[] = $additionalImageFileName;
            }
        }
    }

    // Insert data into the 'Product' table using normal SQL
    $insertSql = "INSERT INTO Product (ProductName, slug, ProductCode, ProductCategories, Availability, Price, Description, ProductMainImage, AdditionalImages, ShortDescription, Status) 
                  VALUES ('$productName', '$slug', '$productCode', '$productCategories', '$availability', $price, '$description', '$mainImageFileName', '" . implode(',', $additionalImageNames) . "', '$shortDescription', '$status')";

    if ($conn->query($insertSql) === TRUE) {
        // Data inserted successfully
        echo '<script>alert("Data inserted successfully.");</script>';
    } else {
        // Error handling
        echo '<script>alert("Error inserting data: ' . $conn->error . '");</script>';
    }
}


    ?>
    
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Product Form</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Product Form</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Product Information</h3>
                        </div>
                        <form method="POST" enctype="multipart/form-data">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="ProductName">Product Name</label>
                                    <input type="text" class="form-control" id="ProductName" name="ProductName" required>
                                </div>
                                <div class="form-group">
                                    <label for="ProductCode">Product Code</label>
                                    <input type="text" class="form-control" id="ProductCode" name="ProductCode" required>
                                </div>
                                <div class="form-group">
                                    <label for="ProductCategories">Product Categories</label>
                                    <select class="form-control" id="ProductCategories" name="ProductCategories">
                                        <?php
                                        // Query to fetch categories
                                            $sql = "SELECT id, CategoryName FROM Category";
                                            $result = $conn->query($sql);
                                            
                                            // Check if there are results
                                            if ($result->num_rows > 0) {
                                                // Output data for each row
                                                while ($row = $result->fetch_assoc()) {
                                                    echo '<option value="' . $row["id"] . '">' . $row["CategoryName"] . '</option>';
                                                }
                                            } else {
                                                echo "No categories found.";
                                            }
                                            ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="Availability">Availability</label>
                                    <select class="form-control" id="Availability" name="Availability">
                                        <option value="InStock">In Stock</option>
                                        <option value="OutOfStock">Out Of Stock</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="Price">Price</label>
                                    <input type="text" class="form-control" id="Price" name="Price" required>
                                </div>
                                <div class="form-group">
                                    <label for="Description">Description</label>
                                    <textarea class="form-control" id="description" name="Description" rows="4" required></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="ProductMainImage">Product Main Image</label>
                                    <input type="file" class="form-control-file" id="ProductMainImage" name="ProductMainImage" required>
                                    <label class="form-control-label" for="ProductMainImage">Choose file</label>
                                </div>

                                <div class="form-group">
                                    <label for="AdditionalImages">Additional Images</label>
                                    <input type="file" class="form-control-file" id="AdditionalImages" name="AdditionalImages[]" multiple>
                                    <label class="form-control-label" for="AdditionalImages">Choose files</label>
                                </div>
                                <div class="form-group">
                                    <label for="ShortDescription">Short Description</label>
                                    <textarea class="form-control" id="ShortDescription" name="ShortDescription" rows="2"></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Status</label>
                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" id="Published" name="Status" value="Published">
                                        <label class="form-check-label" for="Published">Published</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="radio" class="form-check-input" id="Draft" name="Status" value="Draft">
                                        <label class="form-check-label" for="Draft">Draft</label>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>


<?php include("./includes/footer.php"); 

}
?>
