<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (
            isset($_POST['Name']) &&
            isset($_POST['Email']) &&
            isset($_POST['PhoneNumber']) &&
            isset($_POST['Password'])
        ) {
            $name = $_POST['Name'];
            $email = $_POST['Email'];
            $phoneNumber = $_POST['PhoneNumber'];
            $password = $_POST['Password'];
            $address = isset($_POST['Address']) ? $_POST['Address'] : null;
            $city = isset($_POST['City']) ? $_POST['City'] : null;
            $zipCode = isset($_POST['ZipCode']) ? $_POST['ZipCode'] : null;
            $state = isset($_POST['State']) ? $_POST['State'] : null;
            $country = isset($_POST['Country']) ? $_POST['Country'] : null;

            // Hash the password for security
            $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

            // Assuming you have a database connection in db_config.php
            $sql = "INSERT INTO Customers (Name, Email, PhoneNumber, Password, Address, City, ZipCode, State, Country) 
                    VALUES ('$name', '$email', '$phoneNumber', '$hashedPassword', '$address', '$city', '$zipCode', '$state', '$country')";
            $result = mysqli_query($conn, $sql);

            if ($result) {
                echo '<script>alert("Customer Added");</script>';
            } else {
                echo '<script>alert("Failed to add customer.");</script>';
            }
        }
    }

?>
    
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add Customer</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Add Customer</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Customer Information</h3>
                        </div>
                        <form method="POST" id="customerForm">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="Name">Name</label>
                                    <input type="text" class="form-control" id="Name" name="Name" required>
                                </div>
                                <div class="form-group">
                                    <label for="Email">Email</label>
                                    <input type="email" class="form-control" id="Email" name="Email" required>
                                </div>
                                <div class="form-group">
                                    <label for="PhoneNumber">Phone Number</label>
                                    <input type="tel" class="form-control" id="PhoneNumber" name="PhoneNumber" required>
                                </div>
                                <div class="form-group">
                                    <label for="Password">Password</label>
                                    <input type="password" class="form-control" id="Password" name="Password" required>
                                </div>
                                <div class="form-group">
                                    <label for="Address">Address</label>
                                    <input type="text" class="form-control" id="Address" name="Address">
                                </div>
                                <div class="form-group">
                                    <label for="City">City</label>
                                    <input type="text" class="form-control" id="City" name="City">
                                </div>
                                <div class="form-group">
                                    <label for="ZipCode">Zip Code</label>
                                    <input type="text" class="form-control" id="ZipCode" name="ZipCode">
                                </div>
                                <div class="form-group">
                                    <label for="State">State</label>
                                    <input type="text" class="form-control" id="State" name="State">
                                </div>
                                <div class="form-group">
                                    <label for="Country">Country</label>
                                    <input type="text" class="form-control" id="Country" name="Country">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Customer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php include("./includes/footer.php");
}
?>
