<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['PageTitle']) && isset($_POST['PageContent'])) {
            $pageTitle = $_POST['PageTitle'];
            $pageContent = $_POST['PageContent'];

            // Validate and sanitize input
            $pageTitle = htmlspecialchars(strip_tags($pageTitle));

            // For HTML content, you can store it as is without additional sanitation
            $pageContent = $_POST['PageContent'];

            // Function to generate a slug
            function generateSlug($text) {
                $text = strtolower(str_replace(" ", "-", $text));
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($pageTitle);

            // Assuming you have a database connection in db_config.php
            $sql = "INSERT INTO ContentPages (PageTitle, PageContent, Slug) VALUES (?, ?, ?)";
            
            // Use prepared statement
            $stmt = mysqli_prepare($conn, $sql);

            if ($stmt) {
                // Bind parameters
                mysqli_stmt_bind_param($stmt, 'sss', $pageTitle, $pageContent, $slug);

                // Execute the statement
                $result = mysqli_stmt_execute($stmt);

                if ($result) {
                    echo '<script>alert("Content Page Added");</script>';
                } else {
                    // Display an error message
                    echo "Error: " . mysqli_stmt_error($stmt);
                }

                // Close the statement
                mysqli_stmt_close($stmt);
            } else {
                // Display an error message
                echo "Error: " . mysqli_error($conn);
            }
        }
    }

?>



<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add Content Page</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Add Content Page</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Content Page Information</h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="PageTitle">Page Title</label>
                                    <input type="text" class="form-control" id="PageTitle" name="PageTitle" required>
                                </div>
                                <div class="form-group">
                                    <label for="PageContent">Page Content</label>
                                    <textarea class="form-control" id="PageContent" name="PageContent" rows="5" required></textarea>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Content Page</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php include("./includes/footer.php"); ?>

<?php

}

?>