<?php
include("./includes/db_config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
} else {
    include("./includes/header.php");

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['CategoryName'])) {
            $categoryName = $_POST['CategoryName'];
             function generateSlug($text) {
                // Replace spaces with hyphens and make the text lowercase
                $text = strtolower(str_replace(" ", "-", $text));
                // Remove any characters that are not letters, numbers, or hyphens
                $text = preg_replace("/[^a-z0-9-]/", "", $text);
                return $text;
            }
            
            $slug = generateSlug($categoryName);

            // Assuming you have a database connection in db_config.php
            // Insert the category into the database
            $sql = "INSERT INTO Category (CategoryName, slug) VALUES ('$categoryName', '$slug')";
            $result = mysqli_query($conn, $sql);

            if ($result) {
                echo '<script>alert("Category Added");</script>';
            }
        }
    }

?>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Add Category</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Add Category</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Category Information</h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="CategoryName">Category Name</label>
                                    <input type="text" class="form-control" id="CategoryName" name="CategoryName" required>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Add Category</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>


<?php include("./includes/footer.php"); ?>

<?php

}

?>
