<?php
session_start();
include 'includes/db_config.php'; // Include your database connection script here

if (isset($_POST['product_id'])) {
    // Get the product ID from the AJAX request
    $product_id = $_POST['product_id'];

    // Build a SQL query to fetch product details
    $sql = "SELECT * FROM Product WHERE id = $product_id"; // Modify this query as needed

    // Execute the query to fetch product details
    $result = mysqli_query($conn, $sql); // Replace $your_db_connection with your actual database connection variable

    if ($result) {
        $product_details = mysqli_fetch_assoc($result);

        if ($product_details) {
            // If the product details are found, add them to the wishlist session
            if (!isset($_SESSION['wishlist'])) {
                $_SESSION['wishlist'] = array();
            }

            // Check if the product is already in the wishlist
            if (!in_wishlist($product_id, $_SESSION['wishlist'])) {
                $_SESSION['wishlist'][] = $product_details;
                $response = array("success" => "Product added to wishlist.");
            } else {
                $response = array("already_in_wishlist" => "Product is already in the wishlist.");
            }
        } else {
            // Product not found in the database
            $response = array("error" => "Product not found.");
        }
    } else {
        // Database query error
        $response = array("error" => "Database query error: " . mysqli_error($conn)); // Use the correct connection variable
    }
} else {
    $response = array("error" => "Product ID is missing.");
}

echo json_encode($response);

// Function to check if a product is already in the wishlist
function in_wishlist($product_id, $wishlist) {
    foreach ($wishlist as $item) {
        if ($item['id'] == $product_id) {
            return true;
        }
    }
    return false;
}
?>
