<?php
session_start();
include 'includes/db_config.php'; // Include your database connection script here

if (isset($_POST['product_id'])) {
    $product_id = $_POST['product_id'];
    $quantity = isset($_POST['quantity']) ? (int)$_POST['quantity'] : 1; // Get the quantity value (default to 1)

    // Build a prepared statement to fetch product details
    $sql = "SELECT * FROM Product WHERE id = ?";
    
    // Prepare the statement
    $stmt = mysqli_prepare($conn, $sql);
    
    // Bind the product_id parameter to the prepared statement
    mysqli_stmt_bind_param($stmt, 'i', $product_id);
    
    // Execute the prepared statement
    mysqli_stmt_execute($stmt);

    // Get the result
    $result = mysqli_stmt_get_result($stmt);

    if ($result) {
        $product_details = mysqli_fetch_assoc($result);

        if ($product_details) {
            // If the product details are found, add them to the cart session
            if (!isset($_SESSION['cart'])) {
                $_SESSION['cart'] = array();
            }

            // Check if the product is already in the cart
            if (!in_cart($product_id, $_SESSION['cart'])) {
                // Add the quantity information to the product details
                $product_details['quantity'] = $quantity;
                $_SESSION['cart'][] = $product_details;
                $response = array("success" => "Product added to cart.");
            } else {
                $response = array("already_in_cart" => "Product is already in the cart.");
            }
        } else {
            // Product not found in the database
            $response = array("error" => "Product not found.");
        }
    } else {
        // Database query error
        $response = array("error" => "Database query error: " . mysqli_error($conn));
    }
} else {
    $response = array("error" => "Product ID is missing.");
}

echo json_encode($response);

// Function to check if a product is already in the cart
function in_cart($product_id, $cart) {
    foreach ($cart as $item) {
        if ($item['id'] == $product_id) {
            return true;
        }
    }
    return false;
}
?>
